﻿<%@ Language = "VBScript" %>
<%
' XKLog 安装文件
'
' 更新：2009-2-28
' 版本：V0.7

Option Explicit
Response.Buffer = True
Response.CharSet="UTF-8"
Server.ScriptTimeOut = 90
%>
<!-- #include file = "Include/Config.asp" -->
<!-- #include file = "Include/MD5.asp" -->
<!-- #include file = "Function/Function.asp" -->
<%
' 检查博客是否安装过
If SuperPassWord <> "YourPassWord" Then
	ShowError "<li>XKLog 似乎已经安装过了，请勿重复安装。</li><li>如果您确实需要重装 XKLog，请登录后台管理进行相应操作。</li><li>还有疑问，请访问 <a href=""http://bbs.xklab.cn/"">支持论坛</a> 寻求帮助。</li>"
End If

Select Case Request.QueryString("step")
Case "1"
	Step_1()
Case "2"
	Step_2()
Case "3"
	Step_3()
Case "4"
	Step_4()
Case "5"
	Step_5()
Case Else
	Main()
End Select

Sub Main()
	ShowHead "欢迎来到 XKLog 世界！"
%>
<body>
<h1 id="logo" style="text-align: center">XKLog V0.7 安装程序</h1>
<p style="text-align: center">XKLog! 开源个人博客系统!</p>

<h1>作者的话</h1>
<ul>
	<li>如果你觉得这个界面有点眼熟，请不要惊讶，因为这个文件是从 WordPress 抄来的 O(∩_∩)O  我偷一下懒啦~ ~ ~</li>
	<li>您需要花一分钟时间进行博客安装。安装过程不能中断，请确认您现在处于无所事事的状态~ ~</li>
	<li>如果你对 XKLog 有任何建议、想法、评论或发现 Bug，请加入<a href="http://bbs.xklab.cn/">支持论坛</a>。</li>
</ul>

<h1>版权许可</h1>
<p>XKLog 基于 <abbr title="GNU Public License">GPL</abbr> 通用许可协议发布。见(英文) <a href="license.txt">license.txt</a>。</p>

<form action="Install.asp?step=1" method="post">
	<center><input type="submit" name="Submit" class="button" value="下一步" /></center>
<form>
</body>
<%
End Sub

Sub Step_1()
	Dim BlogPath, DataName, BlogDomain
	ShowHead "第一步 基本信息"
	BlogPath = Request.ServerVariables("SCRIPT_NAME")
	BlogPath = Replace(BlogPath, "Install.asp", "")
	DataName = "XKLog_" & GetKey(3) & "#" & GetKey(3) & "%23" & GetKey(3) & ".mdb"
	BlogDomain = "http://" & Request.ServerVariables("SERVER_NAME") & "/"
%>
<body>
<h1 class="step">第一步 基本信息</h1>
<form action="Install.asp?step=2" method="post">
	<table border="0">
	<tr>
		<td>域名信息：</td>
		<td><input name="BlogDomain" type="text" size="30" value="<%= BlogDomain %>" /></td>
	</tr>
	<tr>
		<td></td>
		<td><p>要以 "http://" 开头，以 "/" 结束</p></td>
	</tr>
	<tr>
		<td>安装路径：</td>
		<td><input name="BlogPath" type="text" size="30" value="<%= BlogPath %>" /></td>
	</tr>
	<tr>
		<td></td>
		<td><p>"/" 为安装到根目录，"/blog/" 为安装到 blog 子目录</p></td>
	</tr>
	<tr>
		<td>数据库名称：</td>
		<td><input name="DataName" type="text" size="30" value="<%= DataName %>" /></td>
	</tr>
	<tr>
		<td></td>
		<td><p>XKLog 会为您重命名数据库以保护您的数据</p></td>
	</tr>
	<tr>
		<td>前缀字符：</td>
		<td><input name="PrefixStr" type="text" size="30" value="XKLog_" /></td>
	</tr>
	<tr>
		<td></td>
		<td><p>如果需要安装多个程序副本，您必须修改此项</p></td>
	</tr>
	</table>

	<center><input type="submit" name="Submit" class="button" value="下一步" /></center>
<form>
</body>
<%
End Sub

Sub Step_2()
	If Trim(Request.Form("BlogDomain")) <> "" Then
		Session("XKLog_BlogDomain") = Request.Form("BlogDomain")
	Else
		ShowError "<li>您没有输入<b>域名信息</b>。</li><li>点击 <a href=""#"" onclick=""javascript:history.back()"">这里</a> 返回。</li>"
	End If
	If Trim(Request.Form("BlogPath")) <> "" Then
		Session("XKLog_BlogPath") = Request.Form("BlogPath")
	Else
		ShowError "<li>您没有输入<b>安装路径</b>。</li><li>点击 <a href=""#"" onclick=""javascript:history.back()"">这里</a> 返回。</li>"
	End If
	If Trim(Request.Form("DataName")) <> "" Then
		Session("XKLog_DataName") = Request.Form("DataName")
	Else
		ShowError "<li>您没有输入<b>数据库名称</b>。</li><li>点击 <a href=""#"" onclick=""javascript:history.back()"">这里</a> 返回。</li>"
	End If
	If Trim(Request.Form("PrefixStr")) <> "" Then
		Session("XKLog_PrefixStr") = Request.Form("PrefixStr")
	Else
		ShowError "<li>您没有输入<b>前缀字符</b>。</li><li>点击 <a href=""#"" onclick=""javascript:history.back()"">这里</a> 返回。</li>"
	End If
	ShowHead "第二步 博客信息"
%>
<body>
<h1 class="step">第二步 博客信息</h1>
<form action="Install.asp?step=3" method="post">
	<table border="0">
	<tr>
		<td>博客名称：</td>
		<td><input name="BlogName" type="text" size="30" value="我的部落格" /></td>
	</tr>
	<tr>
		<td></td>
		<td><p>输入您的博客名称。不用担心，您以后仍然可以修改此项设置 ^_^</p></td>
	</tr>
	<tr>
		<td>博客描述：</td>
		<td><input name="BlogDescription" type="text" size="30" value="不要把光阴遗忘，乘着风追，落到有永恒的地方" /></td>
	</tr>
	<tr>
		<td></td>
		<td><p>输入您的博客描述。同样地，您以后仍然可以修改此项设置。</p></td>
	</tr>
	</table>

	<center><input type="submit" name="Submit" class="button" value="下一步" /></center>
<form>
</body>
<%
End Sub

Sub Step_3()
	If Trim(Request.Form("BlogName")) <> "" Then
		Session("XKLog_BlogName") = Request.Form("BlogName")
	Else
		ShowError "<li>您没有输入<b>博客名称</b>。</li><li>点击 <a href=""#"" onclick=""javascript:history.back()"">这里</a> 返回。</li>"
	End If
	If Trim(Request.Form("BlogDescription")) <> "" Then
		Session("XKLog_BlogDescription") = Request.Form("BlogDescription")
	Else
		ShowError "<li>您没有输入<b>博客描述</b>。</li><li>点击 <a href=""#"" onclick=""javascript:history.back()"">这里</a> 返回。</li>"
	End If
	ShowHead "第三步 用户信息"
%>
<body>
<h1 class="step">第三步 用户信息</h1>
<form action="Install.asp?step=4" method="post">
	<table border="0">
	<tr>
		<td>管理员名称：</td>
		<td><input name="AdminName" type="text" size="30" value="admin" /></td>
	</tr>
	<tr>
		<td></td>
		<td><p>输入您的大名。想好了，以后可不能改了 ^_^</p></td>
	</tr>
	<tr>
		<td>前台密码：</td>
		<td><input name="PassWord" type="text" size="30" value="admin" /></td>
	</tr>
	<tr>
		<td></td>
		<td><p>输入您的前台密码。最好八位以上，包含字母、数字和符号，但是不要复杂到自己都忘记了o(╯□╰)o</p></td>
	</tr>
	<tr>
		<td>后台密码：</td>
		<td><input name="SuperPassWord" type="text" size="30" value="admin888" /></td>
	</tr>
	<tr>
		<td></td>
		<td><p>输入您的后台密码。必须和前台密码不相同。</p></td>
	</tr>
	</table>

	<center><input type="submit" name="Submit" class="button" value="下一步" /></center>
<form>
</body>
<%
End Sub

Sub Step_4()
	If Trim(Request.Form("AdminName")) <> "" Then
		Session("XKLog_AdminName") = Request.Form("AdminName")
	Else
		ShowError "<li>您没有输入<b>管理员名称</b>。</li><li>点击 <a href=""#"" onclick=""javascript:history.back()"">这里</a> 返回。</li>"
	End If
	If Trim(Request.Form("PassWord")) <> "" Then
		Session("XKLog_PassWord") = Request.Form("PassWord")
	Else
		ShowError "<li>您没有输入<b>前台密码</b>。</li><li>点击 <a href=""#"" onclick=""javascript:history.back()"">这里</a> 返回。</li>"
	End If
	If Trim(Request.Form("SuperPassWord")) <> "" Then
		Session("XKLog_SuperPassWord") = Request.Form("SuperPassWord")
	Else
		ShowError "<li>您没有输入<b>后台密码</b>。</li><li>点击 <a href=""#"" onclick=""javascript:history.back()"">这里</a> 返回。</li>"
	End If
	If Trim(Request.Form("SuperPassWord")) = Trim(Request.Form("PassWord")) Then
		Session("XKLog_SuperPassWord") = ""
		Session("XKLog_PassWord") = ""
		ShowError "<li>您输入的<b>前台密码</b>与<b>后台密码</b>相同。</li><li>点击 <a href=""#"" onclick=""javascript:history.back()"">这里</a> 返回。</li>"
	End If
	ShowHead "准备就绪"
%>
<body>
<h1 class="step">准备就绪</h1>
<ul>
	<li>好了，所有信息都输入完毕了，请确认以下信息无误：</li>
	<li><b>  域名信息：</b><%= Session("XKLog_BlogDomain") %></li>
	<li><b>  安装路径：</b><%= Session("XKLog_BlogPath") %></li>
	<li><b>数据库名称：</b><%= Session("XKLog_DataName") %></li>
	<li><b>  前缀字符：</b><%= Session("XKLog_PrefixStr") %></li>
	<li><b>  博客名称：</b><%= Session("XKLog_BlogName") %></li>
	<li><b>  博客描述：</b><%= Session("XKLog_BlogDescription") %></li>
	<li><b>管理员名称：</b><%= Session("XKLog_AdminName") %></li>
	<li><b>  前台密码：</b><%= Session("XKLog_PassWord") %></li>
	<li><b>  后台密码：</b><%= Session("XKLog_SuperPassWord") %></li>
	<li>如果没有问题，请点击 下一步 开始安装。</li>
</ul>

<form action="Install.asp?step=5" method="post">
	<center><input type="submit" name="Submit" class="button" value="下一步" /></center>
<form>
</body>
<%
End Sub

Sub Step_5()
	ShowHead "正在安装……"
%>
<body>
<h1 class="step">正在安装……</h1>
<ul>
	<li>正在为您安装 XKLog V0.7 RC，请稍候……</li>
	<li>安装期间请勿刷新或关闭页面。</li>
</ul>
<%
	Response.Flush
	Dim ConfigFile, Fso
	Set Fso = Server.CreateObject("Scripting.FileSystemObject")
	If Not Fso.FileExists( Server.MapPath( Session("XKLog_BlogPath") & "Database/XKLog.mdb" ) ) Then
		ShowError "<li>未能找到 Database/XKLog.mdb。</li><li>请确认您已经完整上传程序文件。</li><li>还有疑问，请访问 <a href=""http://bbs.xklab.cn/"">支持论坛</a> 寻求帮助。</li>"
	Else
		Fso.CopyFile Server.MapPath( Session("XKLog_BlogPath") & "Database/XKLog.mdb" ), Server.MapPath( Session("XKLog_BlogPath") & "Database/" & Session("XKLog_DataName") )
	End If
	' 建立数据表
	Data_Create( Session("XKLog_BlogPath") & "Database/" & Session("XKLog_DataName") )
	' 修改配置文件
	ConfigFile = LoadFile( Session("XKLog_BlogPath") & "Include/Config.asp" )
	ConfigFile = Replace( ConfigFile, "YourBlogPath", Session("XKLog_BlogPath") )
	ConfigFile = Replace( ConfigFile, "YourPrefixStr", Session("XKLog_PrefixStr") )
	ConfigFile = Replace( ConfigFile, "YourPassWord", MD5( Session("XKLog_PrefixStr") & Session("XKLog_SuperPassWord"), 32) )
	ConfigFile = Replace( ConfigFile, "YourDataPath", Session("XKLog_BlogPath") & "Database/" & Session("XKLog_DataName") )
	Call SaveFile( ConfigFile,Session("XKLog_BlogPath") & "Include/Config.asp" )
%>
<h1 class="step">安装完成</h1>
<ul>
	<li>恭喜你，XKLog 已经安装完毕！Just enjoy it！</li>
	<li>点击 <a href="Default.asp">这里</a> 前往首页。</li>
</ul>
</body>
<%
	Session.Contents.RemoveAll()
End Sub
%>
</html>
<%
'--------------------------------------------
' 名称：Data_Create( DataPath )
' 作用：建立 XKLog 运行所需的数据库
'--------------------------------------------
Sub Data_Create( DataPath )
	Dim Conn
	Set Conn = Server.CreateObject("Adodb.Connection")
	Conn.Open = "Provider=Microsoft.jet.OLEDB.4.0;Data Source=" & Server.MapPath( DataPath )
	Conn.Execute( "CREATE TABLE [" & Session("XKLog_PrefixStr") & "Set] ([BlogName] varchar(50),[Description] varchar(255),[KeyWords] varchar(255),[BeiAn] varchar(50),[Domain] varchar(100),[BuildDate] varchar(50),[VisitNum] int default 1,[TodayNum] int default 1,[MaxPerPage] int default 8,[MaxOnline] int default 100,[FilterWords] text,[NameFilter] text,[Enable] bit default True,[CloseReason] varchar(255) default '博客维护中……',[RegEnable] bit default True,[Comment] int default 0,[ComTimer] int default 0,[ComMaxLength] int default 300,[ArtMaxLength] int default 20000,[ArtType] varchar(50) default '半静态',[ShowType] int default 0,[Verify] int default 1,[Version] varchar(50),[Style] varchar(50) default 'Default')" )
	Conn.Execute( "CREATE TABLE [" & Session("XKLog_PrefixStr") & "Article] ([ID] int identity (1, 1) not null constraint primarykey primary key,[Title] varchar(255),[Date] varchar(50),[Time] varchar(50),[Author] varchar(50),[Class] varchar(50),[Tag] varchar(50),[IsTop] bit default False,[IsDel] bit default False,[Content] text,[Read] int default 0,[Comment] int default 0,[Type] varchar(10) default '动态',[Address] varchar(10),[About] bit default True,[Update] bit default False)" )
	Conn.Execute( "CREATE TABLE [" & Session("XKLog_PrefixStr") & "Guestbook] ([GID] int identity (1, 1) not null constraint primarykey primary key,[Author] varchar(50),[IsDel] bit default False,[Email] varchar(255),[QQNum] int,[Index] varchar(255),[Date] varchar(50),[Time] varchar(50),[Guestbook] text,[ReplyUser] varchar(50),[Reply] text,[ReplyDate] varchar(50),[ReplyTime] varchar(50),[IsShow] bit default True)" )
	Conn.Execute( "CREATE TABLE [" & Session("XKLog_PrefixStr") & "Comment] ([CID] int identity (1, 1) not null constraint primarykey primary key,[ArticleID] int default 1,[IsDel] bit default False,[Author] varchar(50),[Email] varchar(255),[Index] varchar(255),[QQNum] int,[Date] varchar(50),[Time] varchar(50),[Comment] text,[ReplyUser] varchar(50),[Reply] text,[ReplyDate] varchar(50),[ReplyTime] varchar(50),[IsShow] bit default True)" )
	Conn.Execute( "CREATE TABLE [" & Session("XKLog_PrefixStr") & "User] ([UID] int identity (1, 1) not null constraint primarykey primary key,[UserName] varchar(50),[PassWord] varchar(50),[Group] int default 0,[IsDel] bit default False,[Email] varchar(255),[QQNum] int,[Index] varchar(255),[IP] varchar(50),[Time] varchar(50))" )
	Conn.Execute( "CREATE TABLE [" & Session("XKLog_PrefixStr") & "Link] ([LID] int identity (1, 1) not null constraint primarykey primary key,[IsDel] bit default False,[Title] varchar(255),[Description] varchar(255),[Address] varchar(255))" )
	Conn.Execute( "CREATE TABLE [" & Session("XKLog_PrefixStr") & "SafeLog] ([SID] int identity (1, 1) not null constraint primarykey primary key,[Description] varchar(255),[Time] varchar(50),[IP] varchar(50))" )
	Conn.Execute( "CREATE TABLE [" & Session("XKLog_PrefixStr") & "Menu] ([MID] int identity (1, 1) not null constraint primarykey primary key,[Num] int,[Name] varchar(50),[Title] varchar(50),[Type] int,[Address] varchar(255))" )
	Conn.Execute( "CREATE TABLE [" & Session("XKLog_PrefixStr") & "Sort] ([SID] int identity (1, 1) not null constraint primarykey primary key,[Num] int,[Name] varchar(255),[Description] varchar(255),[ArticleNum] int default 0)" )
	Conn.Execute( "CREATE TABLE [" & Session("XKLog_PrefixStr") & "Widget] ([WID] int identity (1, 1) not null constraint primarykey primary key,[Name] varchar(50),[Title] varchar(50),[Type] int default 2,[Function] text)" )

	Conn.Execute( "INSERT INTO [" & Session("XKLog_PrefixStr") & "Set] ([BlogName],[Description],[Domain],[BuildDate],[FilterWords],[NameFilter],[Version],[Style]) VALUES ('" & Session("XKLog_BlogName") & "', '" & Session("XKLog_BlogDescription") & "','" & Session("XKLog_BlogDomain") & "','" & DateToStr( Date() & " " & Time(), "Y-m-d zh-cn") & "','Fuck|http://','游客|客人|Admin|Fuck|管理','0.7.241','iNove')" )
	Conn.Execute( "INSERT INTO [" & Session("XKLog_PrefixStr") & "Article] ([Title],[Date],[Time],[Author],[Class],[Tag],[Content],[Read],[Comment]) VALUES ('欢迎使用 XKLog！', '" & Date() & "', '" & Time() & "', '" & Session("XKLog_AdminName") & "', '默认分类','XKLog,欢迎','<p><strong>欢迎使用 XKLog！</strong><br /><br />这是安装程序自动写入的一篇日志，您可以编辑或删除。<br /><br />如果您有任何意见或建议，请访问<a href=""http://www.xklab.cn"">星空工作室</a>。</p>',1,1)" )
	Conn.Execute( "INSERT INTO [" & Session("XKLog_PrefixStr") & "Guestbook] ([Author],[Date],[Time],[Guestbook]) VALUES ('Guest', '" & Date() & "', '" & Time() & "','这是安装程序自动写入的一条留言。')" )
	Conn.Execute( "INSERT INTO [" & Session("XKLog_PrefixStr") & "Comment] ([ArticleID],[Author],[Date],[Time],[Comment],[ReplyUser],[Reply],[ReplyDate],[ReplyTime]) VALUES (1,'Guest', '" & Date() & "', '" & Time() & "','这是安装程序自动写入的一条评论。','" & Session("XKLog_AdminName") & "','这是安装程序自动写入的一条管理员回复。', '" & Date() & "', '" & Time() & "')" )
	Conn.Execute( "INSERT INTO [" & Session("XKLog_PrefixStr") & "User] ([UserName],[PassWord],[Group]) VALUES ('" & Session("XKLog_AdminName") & "','" & MD5( Session("XKLog_PrefixStr") & Session("XKLog_PassWord"), 32) & "',8)" )
	Conn.Execute( "INSERT INTO [" & Session("XKLog_PrefixStr") & "Link] ([Title],[Description],[Address]) VALUES ('星空工作室','XKLog 官方网站','http://www.xklab.cn/')" )
	Conn.Execute( "INSERT INTO [" & Session("XKLog_PrefixStr") & "Sort] ([Num],[Name],[Description],[ArticleNum]) VALUES (1,'默认分类','系统默认分类',1)" )
	Conn.Execute( "INSERT INTO [" & Session("XKLog_PrefixStr") & "Widget] ([WID],[Name],[Title],[Type],[Function]) VALUES (1,'NewArticle','最新日志',0,'Show_NewArticle')" )
	Conn.Execute( "INSERT INTO [" & Session("XKLog_PrefixStr") & "Widget] ([WID],[Name],[Title],[Type],[Function]) VALUES (2,'HotArticle','热门日志',0,'Show_HotArticle')" )
	Conn.Execute( "INSERT INTO [" & Session("XKLog_PrefixStr") & "Widget] ([WID],[Name],[Title],[Type],[Function]) VALUES (3,'RndArticle','随机日志',0,'Show_RndArticle')" )
	Conn.Execute( "INSERT INTO [" & Session("XKLog_PrefixStr") & "Widget] ([WID],[Name],[Title],[Type],[Function]) VALUES (4,'NewComment','最新评论',0,'Show_NewComment')" )
	Conn.Execute( "INSERT INTO [" & Session("XKLog_PrefixStr") & "Widget] ([WID],[Name],[Title],[Type],[Function]) VALUES (5,'NewGuestbook','最新留言',0,'Show_NewGuestbook')" )
	Conn.Execute( "INSERT INTO [" & Session("XKLog_PrefixStr") & "Widget] ([WID],[Name],[Title],[Type],[Function]) VALUES (6,'Category','日志分类',0,'Show_Category')" )
	Conn.Execute( "INSERT INTO [" & Session("XKLog_PrefixStr") & "Widget] ([WID],[Name],[Title],[Type],[Function]) VALUES (7,'Other','其它',0,'Show_Other')" )
	Conn.Execute( "INSERT INTO [" & Session("XKLog_PrefixStr") & "Widget] ([WID],[Name],[Title],[Type],[Function]) VALUES (8,'Link','链接',0,'Show_Link')" )
	Conn.Execute( "INSERT INTO [" & Session("XKLog_PrefixStr") & "Widget] ([WID],[Name],[Title],[Type],[Function]) VALUES (9,'Count','统计',0,'Show_Count')" )
	Conn.Execute( "INSERT INTO [" & Session("XKLog_PrefixStr") & "Menu] ([MID],[Num],[Name],[Title],[Type],[Address]) VALUES (1,1,'Index','首页',0,'Default.asp')" )
	Conn.Execute( "INSERT INTO [" & Session("XKLog_PrefixStr") & "Menu] ([MID],[Num],[Name],[Title],[Type],[Address]) VALUES (2,2,'Guestbook','留言本',0,'Guestbook.asp')" )
	Conn.Close
	Set Conn = Nothing
End Sub

Sub ShowError(Str)
	ShowHead "出错了！"
%>
<body>
<h1 class="step">出错了！</h1>
<ul><%= Str %></ul>
</body>
</html>
<%
	Response.End
End Sub

Sub ShowHead(Str)
%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns = "http://www.w3.org/1999/xhtml" lang = "zh-cn">
<head>
	<meta http-equiv = "Content-Type" content = "text/html; charset=UTF-8" />
	<meta http-equiv = "Content-Language" content = "UTF-8" />
	<title>XKLog - 安装程序 - <%= Str %></title>
	<style>
	html { background: #f7f7f7; }
	body {background: #fff;color: #333;font-family: "Lucida Grande", Verdana, Arial, "Bitstream Vera Sans", sans-serif;margin: 2em auto 0 auto;width: 700px;padding: 1em 2em;-moz-border-radius: 11px;-khtml-border-radius: 11px;-webkit-border-radius: 11px;border-radius: 11px;border: 1px solid #dfdfdf;}
	a { color: #2583ad; text-decoration: none; }
	a:hover { color: #d54e21; }
	h1 {border-bottom: 1px solid #dadada;clear: both;color: #666;font: 24px Georgia, "Times New Roman", Times, serif;margin: 5px 0 0 -4px;padding: 0;padding-bottom: 7px;}
	h2 { font-size: 16px; }
	p, li {padding-bottom: 2px;font-size: 12px;line-height: 18px;}
	code { font-size: 13px; }
	ul, ol { padding: 5px; }
	#logo { margin: 6px 0 14px 0; border-bottom: none;}
	.step {margin: 20px 0 15px;}
	.step, th { text-align: left; padding: 0; }
	.submit input, .button, .button-secondary {font-family: "Lucida Grande", Verdana, Arial, "Bitstream Vera Sans", sans-serif;text-decoration: none;font-size: 14px !important;line-height: 16px;padding: 6px 12px;cursor: pointer;border: 1px solid #bbb;color: #464646;-moz-border-radius: 15px;-khtml-border-radius: 15px;-webkit-border-radius: 15px;border-radius: 15px;-moz-box-sizing: content-box;-webkit-box-sizing: content-box;-khtml-box-sizing: content-box;box-sizing: content-box;}
	.button:hover, .button-secondary:hover, .submit input:hover {color: #000;border-color: #666;}
	.button, .submit input, .button-secondary {background: #f2f2f2 url("Images/white-grad.png") repeat-x scroll left top;}
	.button:active, .submit input:active, .button-secondary:active {background: #eee url("Images/white-grad-active.png") repeat-x scroll left top;}
	</style>
</head>
<%
End Sub
%>